"use client"
import { useState, useRef, useEffect } from "react";
import Popup from "./shared/Popup"; // Adjust the path as necessary
//import eventData from "./shared/data.json"; // Adjust the path as necessary
import './shared/style.css';
const Eventcalendar = (props) => {
  console.log(props);
  const [currentDate, setCurrentDate] = useState(new Date());
  const [selectedDate, setSelectedDate] = useState(new Date().getDate());
  const [hoveredEvent, setHoveredEvent] = useState(null);
  const [clickedEvent, setClickedEvent] = useState(null);

  const popupRef = useRef(null);
 const eventData=props;
  useEffect(() => {
    const handleClickOutside = (event) => {
      if (popupRef.current && !popupRef.current.contains(event.target)) {
        setClickedEvent(null);
        setHoveredEvent(null);
      }
    };

    document.addEventListener("mousedown", handleClickOutside);
    return () => {
      document.removeEventListener("mousedown", handleClickOutside);
    };
  }, [popupRef]);

  const daysOfWeek = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
  const daysOfWeekMobile = ["S", "M", "T", "W", "T", "F", "S"];
  const months = [
    "January",
    "February",
    "March",
    "April",
    "May",
    "June",
    "July",
    "August",
    "September",
    "October",
    "November",
    "December",
  ];

  const getDaysInMonth = (month, year) => {
    return new Date(year, month + 1, 0).getDate();
  };

  const stringToColor = (str) => {
    let hash = 30;
    for (let i = 0; i < str.length; i++) {
      hash = str.charCodeAt(i) + ((hash << 10) - hash);
    }
    const color = `hsl(${hash % 420}, 50%, 50%)`;
    return color;
  };

  const generateCalendar = () => {
    const year = currentDate.getFullYear();
    const month = currentDate.getMonth();
    const firstDayOfMonth = new Date(year, month, 1).getDay();
    const daysInMonth = getDaysInMonth(month, year);

    let days = [];
    let eventsByDay = {};
    let eventPositions = {};

    eventData.items.forEach((event) => {
      const eventStartDate = new Date(event.start_date);
      const eventEndDate = new Date(event.end_date);

      if (
        eventStartDate.getMonth() === month ||
        eventEndDate.getMonth() === month
      ) {
        const startDay =
          eventStartDate.getMonth() === month ? eventStartDate.getDate() : 1;
        const endDay =
          eventEndDate.getMonth() === month
            ? eventEndDate.getDate()
            : daysInMonth;

        let position = eventPositions[event.festival];
        if (position === undefined) {
          position = Object.keys(eventPositions).length;
          eventPositions[event.festival] = position;
        }

        for (
          let i = startDay + firstDayOfMonth - 1;
          i <= endDay + firstDayOfMonth - 1;
          i++
        ) {
          if (!eventsByDay[i]) {
            eventsByDay[i] = [];
          }
          eventsByDay[i].push({
            ...event,
            isFirstDay: i === startDay + firstDayOfMonth - 1,
            isLastDay: i === endDay + firstDayOfMonth - 1,
            position,
          });
        }
      }
    });

    for (let i = 0; i < firstDayOfMonth; i++) {
      days.push(<div className="border h-32" key={`empty-${i}`}></div>);
    }

    for (let day = 1; day <= daysInMonth; day++) {
      const index = day + firstDayOfMonth - 1;
      const events = eventsByDay[index] || [];
      const festivals = events.slice(0, 2);

      days.push(
        <div
          className={`border h-32 relative text-black ${
            selectedDate === day ? "bg-blue-100" : ""
          }`}
          key={day}
          onClick={() => setSelectedDate(day)}
        >
          <div className="w-full relative">
            {festivals.map((event, idx) => (
              <div
                key={idx}
                className="absolute inset-x-0 h-5 flex items-center"
                style={{
                  backgroundColor: stringToColor(event.festival),
                  top: `${event.position * 25}px`,
                }}
              >
                {event.isFirstDay && (
                  <div className="pl-2 text-white text-xs font-bold truncate flex gap-3">
                    <span className="flex justify-center items-center">
                      <svg
                        width="10"
                        viewBox="0 0 16 16"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg"
                      >
                        <path
                          d="M8 0L6.6 1.4L12.2 7H0V9H12.2L6.6 14.6L8 16L16 8L8 0Z"
                          fill="white"
                        />
                      </svg>
                    </span>
                    {event.festival}
                  </div>
                )}
              </div>
            ))}
          </div>

          <div className="absolute bottom-2 right-2 text-lg font-bold">
            {day}
          </div>
          <div className="absolute bottom-2 left-2 flex flex-wrap">
            {events.map((event, index) => (
              <div
                key={index}
                className="w-2 h-2 rounded-full mr-2 cursor-pointer"
                style={{ backgroundColor: stringToColor(event.festival) }}
                onMouseEnter={(e) => {
                  const rect = e.target.getBoundingClientRect();
                  setHoveredEvent({
                    ...event,
                    position: {
                      top: rect.top + window.scrollY,
                      left: rect.left + window.scrollX,
                      right: rect.right + window.scrollX,
                    },
                  });
                }}
                onClick={(e) => {
                  e.stopPropagation();
                  setClickedEvent({
                    ...event,
                    position: {
                      top:
                        e.target.getBoundingClientRect().top + window.scrollY,
                      left:
                        e.target.getBoundingClientRect().left + window.scrollX,
                      right:
                        e.target.getBoundingClientRect().right + window.scrollX,
                    },
                  });
                }}
              ></div>
            ))}
          </div>
        </div>
      );
    }

    return days;
  };

  const goToNextMonth = () => {
    setCurrentDate(new Date(currentDate.setMonth(currentDate.getMonth() + 1)));
  };

  const goToPreviousMonth = () => {
    setCurrentDate(new Date(currentDate.setMonth(currentDate.getMonth() - 1)));
  };

  const getStartOfWeek = (date) => {
    const startDate = new Date(date);
    const day = startDate.getDay();
    const diff = startDate.getDate() - day + (day === 0 ? -6 : 1); // Adjust if day is Sunday
    return new Date(startDate.setDate(diff));
  };

  const goToNextWeek = () => {
    const nextWeek = new Date(currentDate);
    nextWeek.setDate(nextWeek.getDate() + 7);
    setCurrentDate(nextWeek);
    setSelectedDate(nextWeek.getDate());
  };

  const goToPreviousWeek = () => {
    const prevWeek = new Date(currentDate);
    prevWeek.setDate(prevWeek.getDate() - 7);
    setCurrentDate(prevWeek);
    setSelectedDate(prevWeek.getDate());
  };

  const renderMobileView = () => {
    const startOfWeek = getStartOfWeek(currentDate);
    const daysInWeek = Array.from({ length: 7 }, (_, i) => {
      const date = new Date(startOfWeek);
      date.setDate(startOfWeek.getDate() + i);
      return date;
    });

    return (
      <div className="bg-white shadow-md rounded-lg p-4 h-dvh">
        <div className="flex justify-between items-center pb-4">
          <button
            className="text-blue-500 font-bold text-xl"
            onClick={goToPreviousWeek}
          >
            {"<"}
          </button>
          <h1 className="text-xl font-bold text-gray-700">
            {months[currentDate.getMonth()]} {currentDate.getFullYear()}
          </h1>
          <button
            className="text-blue-500 font-bold text-xl"
            onClick={goToNextWeek}
          >
            {">"}
          </button>
        </div>
        <div className="flex justify-around pb-4">
          {daysInWeek.map((date, index) => (
            <div
              key={index}
              className="text-center"
              onClick={() => setSelectedDate(date.getDate())}
            >
              <div className="text-center font-light text-gray-500">
                {daysOfWeekMobile[date.getDay()]}
              </div>
              <div
                className={`text-center font-bold cursor-pointer px-2 py-1.5 w-10 h-10 ${
                  selectedDate === date.getDate()
                    ? "text-white bg-blue-500 rounded-full shadow-md"
                    : "text-gray-700"
                }`}
              >
                {date.getDate()}
              </div>
              <div className="flex items-center justify-center pt-1">
                {eventData.items.some(
                  (event) =>
                    new Date(event.start_date).getDate() <= date.getDate() &&
                    new Date(event.end_date).getDate() >= date.getDate() &&
                    new Date(event.start_date).getMonth() === date.getMonth()
                ) ? (
                  <span className="h-2 w-2 flex items-center justify-center bg-blue-500 rounded-full"></span>
                ) : (
                  <span className="h-2 w-2 flex items-center justify-center bg-gray-200 rounded-full"></span>
                )}
              </div>
            </div>
          ))}
        </div>
        <div className="p-2">
          {eventData.items
            .filter((event) => {
              const eventStartDate = new Date(event.start_date);
              const eventEndDate = new Date(event.end_date);
              return (
                eventStartDate.getDate() <= selectedDate &&
                eventEndDate.getDate() >= selectedDate &&
                eventStartDate.getMonth() === currentDate.getMonth()
              );
            })
            .map((event, idx) => (
              <div
                key={idx}
                className="border p-4 mb-4 rounded-lg shadow-md bg-gray-50"
              >
                <div
                  className="font-bold text-lg"
                  style={{ color: stringToColor(event.festival) }}
                >
                  {event.festival}
                </div>
                <div className="text-sm text-gray-600">
                  {new Date(event.start_date).toLocaleDateString()} -{" "}
                  {new Date(event.end_date).toLocaleDateString()}
                </div>
                <div className="text-sm">{event.description}</div>
              </div>
            ))}
        </div>
      </div>
    );
  };

  return (
    <div className="mx-auto font-sans overflow-hidden relative bg-gray-100 min-h-screen">
      <div className="py-4 flex md:flex-row px-4 justify-between items-center flex-col bg-white shadow-sm">
        <div className="flex-grow">
          <h1 className="text-2xl font-bold text-blue-600 md:text-black ">
            EVENT CALENDAR 2024
          </h1>
        </div>
        <div className="flex items-center space-x-10">
          <div
            className="cursor-pointer flex items-center justify-center text-blue-500 md:text-black"
            onClick={goToPreviousMonth}
          >
            <span className="mr-3">&lt;</span>
            <h1 className="font-semibold text-lg">
              {months[currentDate.getMonth()]} {currentDate.getFullYear()}
            </h1>
          </div>
          <div
            className="cursor-pointer flex items-center justify-center text-blue-500 md:text-black"
            onClick={goToNextMonth}
          >
            <span className="text-lg font-semibold">
              {months[(currentDate.getMonth() + 1) % 12]}
            </span>
            <span className="ml-3">&gt;</span>
          </div>
        </div>
      </div>
      <div className="hidden md:block overflow-x-auto">
        <div className="grid grid-cols-7 p-2 border-t border-gray-200 min-w-[700px] bg-white">
          {daysOfWeek.map((day, index) => (
            <div key={index} className="text-center font-bold">
              {day}
            </div>
          ))}
          {generateCalendar()}
        </div>
      </div>
      <div className="block md:hidden">{renderMobileView()}</div>
      {(hoveredEvent || clickedEvent) && (
        <div ref={popupRef}>
          <Popup
            festival={(hoveredEvent || clickedEvent).heading}
            startDate={new Date((hoveredEvent || clickedEvent).start_date)}
            endDate={new Date((hoveredEvent || clickedEvent).end_date)}
            position={(hoveredEvent || clickedEvent).position}
            description={(hoveredEvent || clickedEvent).description}
            image={(hoveredEvent || clickedEvent).image}
            link={(hoveredEvent || clickedEvent).link}
          />
        </div>
      )}
    </div>
  );
};

export default Eventcalendar;
